/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.internal;

import com.iafenvoy.jupiter.ConfigManager;
import com.iafenvoy.jupiter.config.ConfigSide;
import com.iafenvoy.jupiter.config.ConfigSource;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.render.BadgeRenderer;
import com.iafenvoy.jupiter.render.internal.JupiterConfigListScreen;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class JupiterConfigListWidget
extends class_4280<Entry> {
    private final JupiterConfigListScreen screen;
    private final List<Entry> entries = new ArrayList<Entry>();
    private String filter = "";

    public JupiterConfigListWidget(JupiterConfigListScreen screen, class_310 client, int width, int height, int y, int bottom) {
        super(client, width, height, y, bottom, 32);
        this.screen = screen;
        this.method_31323(false);
    }

    public void update() {
        this.entries.clear();
        for (AbstractConfigContainer x : ConfigManager.getInstance().getConfigs()) {
            this.entries.add(new Entry(this, x));
        }
        this.updateEntries();
    }

    private void updateEntries() {
        this.method_25339();
        this.entries.stream().filter(x -> x.match(this.filter)).forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        this.method_25307(0.0);
    }

    public void setFilter(String filter) {
        this.filter = filter.toLowerCase(Locale.ROOT);
        this.updateEntries();
    }

    protected int method_25329() {
        return this.field_19087 - 8;
    }

    public int method_25322() {
        return this.field_22742 - 4;
    }

    public void setSelected(@Nullable Entry selected) {
        super.method_25313((class_350.class_351)selected);
        this.screen.setOpenConfigState(this.method_25334() != null);
    }

    public static class Entry
    extends class_4280.class_4281<Entry> {
        private final class_310 client = class_310.method_1551();
        private final JupiterConfigListWidget widget;
        private final AbstractConfigContainer handler;

        public Entry(JupiterConfigListWidget widget, AbstractConfigContainer handler) {
            this.widget = widget;
            this.handler = handler;
        }

        public void method_25343(@NotNull class_332 graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            graphics.method_27535(this.client.field_1772, this.handler.getTitle(), x + 65, y + 1, -1);
            graphics.method_25303(this.client.field_1772, this.handler.getConfigId().toString(), x + 65, y + 1 + 9, -8421505);
            graphics.method_25303(this.client.field_1772, this.handler.getPath(), x + 65, y + 1 + 18, -8421505);
            ConfigSource source = this.handler.getSource();
            ConfigSide side = this.handler.getSide();
            BadgeRenderer.draw(graphics, this.client.field_1772, x + 1, y + 1, source.name(), source.color());
            BadgeRenderer.draw(graphics, this.client.field_1772, x + 1, y + 16, (class_2561)TextUtil.literal(side.getDisplayText()), side.getColor());
        }

        public boolean method_25402(double x, double y, int button) {
            this.widget.setSelected(this);
            return false;
        }

        public AbstractConfigContainer getConfigContainer() {
            return this.handler;
        }

        @NotNull
        public class_2561 method_37006() {
            return TextUtil.empty();
        }

        public boolean match(String filter) {
            return this.handler.getTitle().getString().toLowerCase(Locale.ROOT).contains(filter) || this.handler.getConfigId().toString().contains(filter) || this.handler.getPath().contains(filter);
        }
    }
}

